//
//  AuFond.m
//  SLOSYN
//
//  Créé par Miguel Saro le 04/04/12.
//  Tout droits réservés, - Cocoa Pod -, 2012.  
//
//	Valable uniquement pour les fenêtre sans redimensions!

#import "AuFond.h"

#define aWindow o_fenetre


@implementation AppDelegate (AuFond)

- (void)metLeFond:(NSWindow *)theWindow
{

    NSImage *bg = [[NSImage alloc] initWithSize:[aWindow frame].size];
    
    NSImage *bottomLeft = [NSImage imageNamed:@"bottom_left"];
    NSImage *bottomMiddle = [NSImage imageNamed:@"bottom_middle"];
    NSColor *bottomMiddlePattern = [NSColor colorWithPatternImage:bottomMiddle];
    NSImage *bottomRight = [NSImage imageNamed:@"bottom_right"];
    NSImage *topLeft = [NSImage imageNamed:@"top_left"];
    NSImage *topMiddle = [NSImage imageNamed:@"top_middle"];
    NSColor *topMiddlePattern = [NSColor colorWithPatternImage:topMiddle];
    NSImage *topRight = [NSImage imageNamed:@"top_right"];    
    NSImage *lefond = [NSImage imageNamed:@"Ic128"];
	
    // Find background color to draw into window
    [topMiddle lockFocus];
    //NSColor *bgColor = NSReadPixel(NSMakePoint(0, 0));
	NSColor *bgColor = [NSColor colorWithPatternImage:lefond] ;
    [topMiddle unlockFocus];
    
    // Set min width of temporary pattern image to prevent flickering at small widths
    float minWidth = 300.0;
    
    // Create temporary image for top-middle pattern
    NSImage *topMiddleImg = [[NSImage alloc] initWithSize:NSMakeSize(MAX(minWidth, [aWindow frame].size.width), [topMiddle size].height )];
    [topMiddleImg lockFocus];
    [topMiddlePattern set];
    NSRectFill(NSMakeRect(0, 0, [topMiddleImg size].width, [topMiddle size].height ));
    [topMiddleImg unlockFocus];
    
    // Create temporary image for bottom-middle pattern
    NSImage *bottomMiddleImg = [[NSImage alloc] initWithSize:NSMakeSize(MAX(minWidth, [aWindow frame].size.width), [bottomMiddle size].height )];
    [bottomMiddleImg lockFocus];
    [bottomMiddlePattern set];
    NSRectFill(NSMakeRect(0, 0, [bottomMiddleImg size].width, [bottomMiddleImg size].height ));
    [bottomMiddleImg unlockFocus];
    
    // Begin drawing into our main image
    [bg lockFocus];
    
    // Composite current background color into bg
    [bgColor set];
    NSRectFill(NSMakeRect(0, 0, [bg size].width, [bg size].height));
    
    // Composite bottom-middle image
    [bottomMiddleImg drawInRect:NSMakeRect([bottomLeft size].width, 0, 
                                           [bg size].width - [bottomLeft size].width - [bottomRight size].width, 
                                           [bottomLeft size].height) 
                       fromRect:NSMakeRect(0, 0, 
                                           [bg size].width - [bottomLeft size].width - [bottomRight size].width, 
                                           [bottomLeft size].height) 
                      operation:NSCompositeSourceOver 
                       fraction:1.0];
    [bottomMiddleImg release];
    
    // Composite bottom-left and bottom-right images
    [bottomLeft compositeToPoint:NSZeroPoint 
                       operation:NSCompositeSourceOver];
    [bottomRight compositeToPoint:NSMakePoint([bg size].width - [bottomRight size].width, 0) 
                        operation:NSCompositeSourceOver];
    
    // Composite top-middle image
    [topMiddleImg drawInRect:NSMakeRect([topLeft size].width, [bg size].height - [topLeft size].height , 
                                        [bg size].width - [topLeft size].width - [topRight size].width, 
                                        [topLeft size].height ) 
                    fromRect:NSMakeRect(0, 0, 
                                        [bg size].width - [topLeft size].width - [topRight size].width, 
                                        [topLeft size].height) 
                   operation:NSCompositeSourceOver 
                    fraction:1.0];
    [topMiddleImg release];
    
    // Composite top-left and top-right images
    [topLeft compositeToPoint:NSMakePoint(0, [bg size].height - [topLeft size].height) operation:NSCompositeSourceOver];
    [topRight compositeToPoint:NSMakePoint([bg size].width - [topRight size].width, [bg size].height - [topRight size].height) operation:NSCompositeSourceOver];
    
    [bg unlockFocus];
    
    [theWindow setBackgroundColor:[NSColor colorWithPatternImage:bg ]];
}

@end
