//
//  FnConsole.h
//  SLOSYN
//
//  Créé par Miguel Saro le 08/04/12.
//  Tout droits réservés, __La Torréfaction Joyeuse__, 2012.  @interface Console (fonctions)
/*

	Fonction reconnues:

ZUT = 0,			 NULL
SOH = 1,			(Start of Header) 
STX = 2,			(Start of Text)
ETX = 3,			(End of Text)
EOT = 4,			(End of Transmission)
ENQ = 5,			(Enquiry)
ACK = 6,			(Acknowledgment)
BEL = 7,			(Bell)
 BS = 8,			(Backspace) attention, caractères diacritiques
 HT = 9,			(Horizontal Tab)
 LF = 10,			(Line Feed)
 VT = 11,			(Vertical Tab)
 FF = 12,			(Form Feed) 
 CR = 13,			(Carriage Return)
 SO = 14,			(Shift Out)
 SI = 15,			(Shift In)
DLE = 16,			(Data Link Escape)
DC1 = 17,			(XON)(Device Control 1)
DC2 = 18,			(Device Control 2)
DC3 = 19,			(XOFF)(Device Control 3)
DC4 = 20,			(Device Control 4)
NAK = 21,			(Negative Acknowledgement)
SYN = 22,			(Synchronous Idle)
ETB = 23,			(End of Trans. Block)
CAN = 24,			(Cancel)
 EM = 25,			(End of Medium)
SUB = 26,			(Substitute)
ESC = 27,			(Escape)
 FS = 28,			(File Separator)
 GS = 29,			(Group Separator)
 RS = 30,			(Request to Send)(Record Separator)
 US = 31,			(Unit Separator)
DEL = 127,			DEL		Delete last character
NVC = -99			NVC      Not Valide Code

F	""   ne rien faire (avance ruban uniquement)
0	-01  pas d'impression, fin de bloc?
1	-02  Back Space, recule d'un caractère, (diacritique)
2	-03  LF avance d'une ligne,  fin de bloc?
3	-04  CR retour début de ligne, fin de bloc?
4	-05  avance d'une page, fin de bloc
5	-06  Tabulation 4 espaces
6	-07  Son de cloche (BELL)
7	-08
8	-09
9	-10
A	-11
B	-12
C	-13  Fin de tout (bloc, ligne, page, ruban)
D	-14  Baudot letter
E	-15  Baudot figure
F	-16  efface le caractère précédent
	-99  Rien à faire  (réservé, pas de code)
	
' 030D
` 0300
´ 0301
^ 0302
¨ 0308
_ 0332  souligné
- 0336  barré
*/


#import <Cocoa/Cocoa.h>
#import "Console.h"
#import "AppServices.h"

@interface Console (fonctions)


- (NSUInteger)diacritq:(NSUInteger)code ;
- (void)F06 ;										// Son de cloche (BELL)
- (unichar)hexaASCII:(NSUInteger)leKar ;			// Spécifique affichage binaire
- (void)encdASCII:(char)leKar why:(BOOL)why ;		// affichage ASCII en suivant les caractères
- (void)ranger:(NSUInteger)kara nat:(BOOL)natr ;    // range puis affiche
- (void)purge ;

@end
