//
//  Pref.m
//  SLOSYN
//
//  Créé par Miguel Saro le 05/04/12.
//  Tout droits réservés, __La Torréfaction Joyeuse__, 2012.  
//

#import "Pref.h"
#import "Console.h"

@implementation AppDelegate (Pref)


- (void)prefere:(BOOL)gsens									// tranfert les réglages
{									
	if (gsens)						
	 {
		[self lireReglages] ;								// préférences -> variables -> GUI si YES
		
		[o_bCR setState:reg.bCR] ; 
		[o_bLF setState:reg.bLF] ; 
		[o_bETX setState:reg.bETX] ; 
		[o_bEOT setState:reg.bEOT] ; 
		[o_bETB setState:reg.bETB] ; 
		[o_bEM setState:reg.bEM] ; 
		[o_bFS setState:reg.bFS] ;
		[o_bGS setState:reg.bGS] ; 
		[o_bRS setState:reg.bRS] ;
		[o_bUS setState:reg.bUS] ;
		[o_b00 setState:reg.b00] ;
		[o_bff setState:reg.bff] ;
		[o_C00 setStringValue:[NSString stringWithFormat:@"%ld", (long)ct_C00]] ;
		[o_Cff setStringValue:[NSString stringWithFormat:@"%ld", (long)ct_Cff]] ;
	 }
	else 
	 {
		reg.bCR = [o_bCR state]  ;			// CR
		reg.bLF = [o_bLF state]  ;			// LF
		reg.bETX = [o_bETX state]  ;		// Fin bloc
		reg.bEOT = [o_bEOT state]  ;		// Fin bloc
		reg.bETB = [o_bETB state]  ;		// Fin bloc
		reg.bEM = [o_bEM state]  ;			// Fin medium
		reg.bFS = [o_bFS state]  ;			// File separator
		reg.bGS = [o_bGS state]  ;			// Group separator
		reg.bRS = [o_bRS state]  ;			// Record separator
		reg.bUS = [o_bUS state]  ;			// Unit separator
		reg.b00 = [o_b00 state]  ;			// arret sur des nulls
		reg.bff = [o_bff state]  ;			// arret sur des FF
		ct_C00 = [o_C00 intValue] ;			// compte de null
		ct_Cff = [o_Cff intValue] ;			// compte de ff
		
		[self sauveReglages] ;								// gui -> variables -> préférences si NO
	 } ;
}


- (void)sauveReglages												//  -> préférences
{
NSUserDefaults	*defauts ;


	defauts = [NSUserDefaults standardUserDefaults] ;				// pointe le domaine Standard des défauts
	[defauts setObject:preferencesVersion forKey:@"letest"] ;
	[defauts setInteger:[o_combien selectedColumn] forKey:@"combien"] ;
	[defauts setInteger:[r_hexa state] forKey:@"hexa"] ;
	[defauts setInteger:[r_sens state] forKey:@"sens"] ;
	[defauts setInteger:reg.bCR forKey:@"CR"] ; 
	[defauts setInteger:reg.bLF forKey:@"LF"] ; 
	[defauts setInteger:reg.bETX forKey:@"ETX"] ; 
	[defauts setInteger:reg.bEOT forKey:@"EOT"] ; 
	[defauts setInteger:reg.bETB forKey:@"ETB"] ; 
	[defauts setInteger:reg.bEM forKey:@"EM"] ; 
	[defauts setInteger:reg.bFS forKey:@"FS"] ;
	[defauts setInteger:reg.bGS forKey:@"GS"] ; 
	[defauts setInteger:reg.bRS forKey:@"RS"] ; 
	[defauts setInteger:reg.bUS forKey:@"US"] ;
	[defauts setInteger:reg.b00 forKey:@"b00"] ; 
	[defauts setInteger:reg.bff forKey:@"bff"] ;
	[defauts setInteger:ct_C00 forKey:@"Cnull"] ;
	[defauts setInteger:ct_Cff forKey:@"Cff"] ;

	[defauts setObject:[o_consol defoCode] forKey:@"defoCode"] ;
	[defauts setObject:[o_consol chemin] forKey:@"chemin"] ;
	[defauts setObject:[o_consol mechin] forKey:@"mechin"] ;
}

- (void)defautReglages
{
//	[r_type setState:0] ;
	[r_hexa setState:1] ;
	[r_sens setState:1] ;
	[o_bCR setState:0] ; 
	[o_bLF setState:1] ; 
	[o_bETX setState:0] ; 
	[o_bEOT setState:0] ; 
	[o_bETB setState:0] ; 
	[o_bEM setState:0] ; 
	[o_bFS setState:0] ;
	[o_bGS setState:0] ; 
	[o_bRS setState:0] ; 
	[o_bUS setState:0] ;
	[o_b00 setState:0] ;
	[o_bff setState:0] ;
	[o_C00 setStringValue:@"20"] ;
	[o_Cff setStringValue:@"20"] ;
	[o_combien selectCellAtRow:0 column:0] ;
	[o_consol setDefoCode:[[NSBundle mainBundle] pathForResource:@"ASCII7b" ofType:@"code"] ] ;
	[o_consol setChemin:[@"~/Desktop" stringByExpandingTildeInPath] ] ;
	[o_consol setMechin:[@"~/Desktop" stringByExpandingTildeInPath] ] ;
	[self sauveReglages] ;
}

- (void)lireReglages								                // préferences -> GUI
{
NSUserDefaults	*defauts ;
NSString *ghemin ;

	defauts = [NSUserDefaults standardUserDefaults] ;				// pointe le domaine Standard des défauts
	[o_combien selectCellAtRow:0 column:[defauts integerForKey:@"combien"] ] ;
//	[r_type setState:[defauts integerForKey:@"type"] ] ;
	[r_hexa setState:[defauts integerForKey:@"hexa"] ] ;
	[r_sens setState:[defauts integerForKey:@"sens"] ] ;
	reg.bCR = [defauts integerForKey:@"CR"] ; 
	reg.bLF = [defauts integerForKey:@"LF"] ; 
	reg.bETX = [defauts integerForKey:@"ETX"] ; 
	reg.bEOT = [defauts integerForKey:@"EOT"] ; 
	reg.bETB = [defauts integerForKey:@"ETB"] ; 
	reg.bEM = [defauts integerForKey:@"EM"] ; 
	reg.bFS = [defauts integerForKey:@"FS"] ;
	reg.bGS = [defauts integerForKey:@"GS"] ; 
	reg.bRS = [defauts integerForKey:@"RS"] ; 
	reg.bUS = [defauts integerForKey:@"US"] ;
	reg.b00 = [defauts integerForKey:@"b00"] ;
	reg.bff = [defauts integerForKey:@"bff"] ;
	ct_C00  = [defauts integerForKey:@"Cnull"]  ;
	ct_Cff  = [defauts integerForKey:@"Cff"]  ;
	
	ghemin  = [defauts stringForKey:@"defoCode"] ;
	if ((ghemin==nil) || ([ghemin length]==0) || (![[NSFileManager defaultManager] fileExistsAtPath:ghemin]))
		ghemin = [[NSBundle mainBundle] pathForResource:@"ASCII7b" ofType:@"code"] ; // code par défaut.
	[o_consol setDefoCode:[ghemin copy] ] ;
	
	ghemin  = [defauts stringForKey:@"chemin"] ;
	if ((ghemin==nil) || ([ghemin length]==0) || (![[NSFileManager defaultManager] fileExistsAtPath:ghemin]))
		ghemin = [@"~/Desktop" stringByExpandingTildeInPath] ;						// chemin sauve par défaut.
	[o_consol setChemin:[ghemin copy] ] ;
	
	ghemin  = [defauts stringForKey:@"mechin"] ;
	if ((ghemin==nil) || ([ghemin length]==0) || (![[NSFileManager defaultManager] fileExistsAtPath:ghemin]))
		ghemin = [@"~/Desktop" stringByExpandingTildeInPath] ;						// mechin lire par défaut.
	[o_consol setMechin:[ghemin copy] ] ;

}

- (void)existePref
{
NSUserDefaults	*defauts ;
NSString		*letest ;

	defauts = [NSUserDefaults standardUserDefaults] ;				// pointe le domaine Standard des défauts
	letest = [defauts stringForKey:@"letest"] ;
	if ((letest == nil) || ((letest != nil) && (![letest isEqualToString:preferencesVersion])))	 // existe? bonne version?
	 	 [self defautReglages] ;									// mettre les valeurs par défaut
	[self prefere:YES] ;
}

@end
