/*
** Made by fabien le mentec <texane@gmail.com>
** 
** Started on  Wed Nov 11 15:33:43 2009 texane
** Last update Tue Dec 13 10:59:09 2011 fabien le mentec
*/



#ifndef SLOSYN_TYPES_H_INCLUDED
#define SLOSYN_TYPES_H_INCLUDED


/* include stdint before */

#include "zusb.h"


//#define SLOSYN_USB_VENDOR_ID 0x2a2a			remplacés par la lecture du fichier device.strings
//#define SLOSYN_USB_PRODUCT_ID 0xf00f

#define SLOSYN_USB_EP_REQ 1
#define SLOSYN_USB_EP_REP 2



/* ----------- protocol related types ----------- */

typedef uint8_t slosyn_bitmap_t;


/* --------------- error types --------------- */

enum slosyn_error
{
  SLOSYN_ERROR_SUCCESS = 0,
    
  SLOSYN_ERROR_ALREADY_INIT,
  SLOSYN_ERROR_LIBUSB,
  SLOSYN_ERROR_NOT_INIT,
  SLOSYN_ERROR_NOT_FOUND,
  SLOSYN_ERROR_MEMORY,
  SLOSYN_ERROR_TIMEOUT,
  SLOSYN_ERROR_IO,
  SLOSYN_ERROR_EINVAL,

  SLOSYN_ERROR_MAX
};

typedef enum slosyn_error slosyn_error_t;


/* -------------- slosyn request -------------- */

struct slosyn_request
{
  /* command */
#define SLOSYN_REQ_READ 0
#define SLOSYN_REQ_REWIND 1
#define SLOSYN_REQ_ECHO 2
#define SLOSYN_REQ_STATE 3
#define SLOSYN_REQ_INVALID ((uint8_t)-1)
  uint8_t req;

  /* how many chars. 0 for inf.
     note: must not be greater than SLOSYN_NCHARS_MAX.
     bigger read request are handle by chunks.
   */
#define SLOSYN_NCHARS_INF 0
#define SLOSYN_NCHARS_MAX 32
  uint8_t nchars;

  /* forward, backward direction */
#define SLOSYN_DIR_FWD 0
#define SLOSYN_DIR_BWD 1
  uint8_t dir;

  /* FIXME: has to be added, seems due to a SDCC compilation bug */
#define SLOSYN_FIXME_OFFSET 1
  uint8_t chars[SLOSYN_NCHARS_MAX + SLOSYN_FIXME_OFFSET];
}
#ifndef SDCC
__attribute__((packed))
#endif
;

typedef struct slosyn_request slosyn_request_t;


/* -------------- slosyn reply -------------- */

struct slosyn_reply
{
#define SLOSYN_BIT_EOB (1 << 0) /* end of band */
  slosyn_bitmap_t status;

  uint8_t nchars;

  uint8_t chars[SLOSYN_NCHARS_MAX + SLOSYN_FIXME_OFFSET];
}
#ifndef SDCC
__attribute__((packed))
#endif
;

typedef struct slosyn_reply slosyn_reply_t ;

/* -------------- slosyn handle -------------- */

struct slosyn_handle
{
  usb_dev_handle* usb_handle ;

  unsigned int ep_req;
  unsigned int ep_rep;
};

typedef struct slosyn_handle slosyn_handle_t;


/* -------------- slosyn command -------------- */

union slosyn_cmd
{
  slosyn_request_t req;
  slosyn_reply_t rep;
};

typedef union slosyn_cmd slosyn_cmd_t; 


#endif /* ! SLOSYN_TYPES_H_INCLUDED */
