//
//  Console.m
//  SLOSYN
//
//  Créé par Miguel Saro le 03/04/12.
//  Tout droits réservés, - Cocoa Pod -, 2012.
//

#import "Console.h"
#import "FnConsole.h"
#import <Foundation/Foundation.h>

@interface Console (locales)

- (BOOL)faitTable:(NSString *)flcod ;
- (void)voirTable ;
- (void)carK:(NSDictionary *)dico bfr:(uint8 *)ut8 nm:(NSString *)nm ;
- (void)codAret:(NSDictionary *)dico ;
- (NSString *)priseFichier:(NSString *)defautNom ;
- (NSString *)prise_Donnee:(NSString *)defautNom access:(BOOL)sory ;
- (void)flushAll ;
- (void)hexaFlush ;
- (void)nextChar:(NSData *)ceschar ;
- (void)faitHexa ;
- (void)faitText ;
- (void)faitRTF ;
- (void)faitBin ;
- (void)ordonne:(NSString *)sordre ;
- (NSString *)leDossier:(NSString *)piste ;

@end


@implementation Console

- (IBAction)changeCode:(id)sender											// changement du code
{
NSString *choix, *letitre ;													// choisir le nouveau code

	choix = [self prise_Donnee:[self leDossier:defoCode] access:NO] ;
	if ([choix length]==00)
			return ;														// annuler par l'utilisateur
	if ([self faitTable:choix])
	 { [defoCode setString:choix] ;	return ; } ;							// table nouveau code: OK
	letitre = [NSString stringWithFormat:localiser(@"coderr") , [NSApp pathUser:choix]] ;
	[NSApp auFeu:letitre defBouton:@"Ok"] ;
}

- (IBAction)a_hexade:(id)sender												// binaire<->texte
{
	[self attributs:0] ; 
	atri = Sou = MAJ = rtf = NO ; nomb = 0 ; 
	if ([brut length]==0) return ;											// vide -> return
	[fuori setData:brut] ;													// copie temporaire
	[brut setLength:0] ; [o_Text setString:@""] ;							// vide les résultats
	[self nextChar:fuori why:NO] ;											// ré-affiche
}

- (IBAction)a_sauver:(id)sender												// sauver le texte affiché
{
NSString		*sentier ;

	if ([brut length] == 0)
	 {	[NSApp auFeu:localiser(@"erreur06") defBouton:nil ] ;				// rien à sauver
		return ;
	 } ;
	
	sentier = [self priseFichier:[self leDossier:chemin]] ;
	if ([sentier length] == 0) return ;										// annuler par l'utilisateur.
	[chemin setString:[NSString stringWithString:sentier]] ;				//sauve le path
		
	atri = NO ; nomb=0 ;
	[fuori setLength:0] ;
	switch ([o_choix indexOfSelectedItem]) {
	case 0:	[self faitHexa] ; break ;										// valeurs héxa brutes
	case 1: [self faitText] ; break ;										// texte simple
	case 2: [self faitRTF]  ; break ;										// texte rtf
	default:[self faitBin]	; break ;										// fichier binaire
	} ;

	[[NSFileManager defaultManager] createFileAtPath:sentier contents:fuori attributes:nil] ; // sauve le fichier

}

- (IBAction)a_relire:(id)sender												// relire un fichier sauvé
{
NSString		*sentier ;
NSUInteger		ttl, x, y, append ;					
char			*dBuf, *sBuf, val, car1 ;
BOOL			pasHexa ;

	sentier = [self prise_Donnee:[self leDossier:mechin] access:YES] ;
	if ([sentier length] == 0) return ;										// user canceled
	append = [o_ajout indexOfSelectedItem] ;								// ajout ou remplace ?
	
	[fuori setData:[NSData dataWithContentsOfFile:sentier]] ;				// données lues -> NSData
	y = ttl = [fuori length] ;													// Longueur des données
	if (ttl==0) return ;
	if ( [[sentier pathExtension] isEqualToString:@"srt"] ) 
	 {
		[fuori setLength:ttl+20] ;												// ajoute Bytes de sécurité
		sBuf = [fuori mutableBytes] ;											// pointeur des données scanf hexa
		dBuf = sBuf ;
		[mechin setString:[NSString stringWithString:sentier]] ;
	
		for (x=0, y=0 ; x<ttl ; )
		{	pasHexa = NO ;
			val = 0 ;
			do {
				car1 = sBuf[x++] ;												// prise 1 ascii			
				if (car1 >= '0' &&  car1 <= '9')								// conversion ascii->hexa
					val = (val*16) + (car1-'0') ;
				else if (car1 >= 'a' &&  car1 <= 'f')
					val = (val*16) + (car1-'a' + 0xa) ;
				else if (car1 >= 'A' &&  car1 <= 'F')
					val = (val*16) + (car1-'A' + 0xa) ;
				else
					pasHexa = YES ;												// pas hexa,
			} while ((pasHexa == NO) && (x<ttl)) ;
	
			dBuf[y++] = val ;													// sauve la valeur
		} ;
	 } ;
	
	[fuori setLength:y] ; 
	
	if (append == 1)
	 {	[brut setLength:0] ; [o_Text setString:@""] ; } ;
	 
	atri = Sou = MAJ = rtf = NO ; nomb = 0 ;	
	[self nextChar:fuori why:NO] ;											// affiche l'entrée
}

- (IBAction)a_ascii7:(id)sender												// code par défaut: ASCII 7bits
{
	[self faitTable:[[NSBundle mainBundle] pathForResource:@"ASCII7b" ofType:@"code"] ] ;
}

- (IBAction)a_codage:(id)sender												// afficher les caractères du code
{
	[self voirTable] ;
}

- (IBAction)a_efface:(id)sender												// effacer la console
{
	[o_Text setString:@""] ;
	[lu setString:@""] ;
	[brut setLength:0] ;
	nomb=0 ;
}

- (void)consolInit															// initialise la console ?
{
	[o_Text setString:@""] ;
	[lu setString:@""] ;
}

- (void) fermeConsole
{
	[o_display orderOut:self] ;
}

- (void)flushAll															// vide le buffer
{
	if (nomb == 0) return ;
	[self hexaFlush] ;
	recu[0] = 0 ; 
	nomb = 0 ;
}   

// ----------------------------------------------------------------------

- (void)awakeFromNib
{
NSArray	*fontes ;

	defoCode = [NSMutableString stringWithCapacity:50] ; [defoCode setString:@""] ; [defoCode retain] ;
	nameCode = [NSMutableString stringWithCapacity:50] ; [nameCode setString:@""] ; [nameCode retain] ;
	tmpArray = [NSMutableArray	arrayWithCapacity:50]  ; [tmpArray retain] ;
	lu = [NSMutableString stringWithCapacity:50] ; [lu setString:@""] ; [lu retain] ;
	chemin = [NSMutableString stringWithCapacity:50] ; [chemin setString:@""] ; [chemin retain] ;
	mechin = [NSMutableString stringWithCapacity:50] ; [mechin setString:@""] ; [mechin retain] ;
	nV = 65533 ;
	fontes = [[NSFontManager sharedFontManager] availableFontFamilies] ;
	if ([fontes containsObject:@"Menlo"] )
		lafonte = [NSFont fontWithName:@"Menlo" size:13.0] ;
	else if ([fontes containsObject:@"Andale Mono"] )
		lafonte = [NSFont fontWithName:@"Andale Mono" size:13.0] ;
	else if ([fontes containsObject:@"Monaco"] )
		lafonte = [NSFont fontWithName:@"Monaco" size:13.0] ;
	else if ([fontes containsObject:@"Courier"] )
		lafonte = [NSFont fontWithName:@"Courier" size:13.0] ;
	else
		lafonte = [NSFont userFixedPitchFontOfSize:13.0] ;
	[lafonte retain] ;
	attr = [NSDictionary dictionaryWithObject:lafonte forKey:NSFontAttributeName] ;				// */
	atts = [NSMutableDictionary dictionaryWithCapacity:5] ;
	[attr retain] ; [atts retain] ;
	[o_Text setString:@""] ;

	majuscules = [NSCharacterSet uppercaseLetterCharacterSet] ; [majuscules retain] ;
	axents = [NSCharacterSet characterSetWithCharactersInString:accents] ; [axents retain] ;
	brut = [NSMutableData dataWithCapacity:1000] ; [brut retain] ;
	fuori = [NSMutableData dataWithCapacity:1000] ; [fuori retain] ;
	red = [NSColor redColor] ; [red retain] ;
	nomb = 0 ; recu[0] = 0 ; rtf = NO ;
	arret[0] = ETXr[0] = EOTr[0] = CRr[0] = LFr[0] = ETBr[0] = EMr[0] = FSr[0] = GSr[0] = RSr[0] = USr[0] = 0 ;
	strtf = [[NSMutableAttributedString alloc] initWithString:@""] ;
}

// ---------------------------------------------------------------------- Table d'encodage

- (BOOL)faitTable:(NSString *)flcod
{
BOOL            noexep ;
NSDictionary	*tempDico, *divr ;
NSMutableString *mf ;
NSString		*indx, *F, *G, *sordre ;
NSInteger		valr ;
NSArray			*lignes ;
NSStringEncoding  encd ;
NSRange         dfin ;
NSUInteger		debutLn, debutLnNext, finLn, finString;
id	ppl ;


	mf = [NSMutableString stringWithCapacity:50] ;
	[mf setString:[NSString stringWithContentsOfFile:flcod usedEncoding:&encd error:NULL]] ;
	dfin = [mf rangeOfString:@"/*character*/"] ;

	tempDico = [NSDictionary dictionaryWithContentsOfFile:flcod] ;
	lignes = [tempDico allKeys] ;
	if ((tempDico == nil) || ((tempDico != nil) && ([lignes count]<15)) || (dfin.location == NSNotFound))
			return NO ;
	if (![lignes containsObject:@"name"] || ![lignes containsObject:@"mask"] || ![lignes containsObject:@"divr"])
			return NO ;

	[defoCode setString:flcod] ;										// sauve le chemin du fichier de code
	[nameCode setString:[tempDico objectForKey:@"name"]] ;				// nom de ce code
	[o_nomc setStringValue:nameCode] ;									// met le nom dans la fenêtre
	
	[self codAret:tempDico] ;											// 
	
	tablmask = 255 ;
	if ([lignes containsObject:@"mask"]) 
	 	tablmask = [[tempDico objectForKey:@"mask"] integerValue] ;		// Masque

	shiftHow = 0 ;
	if ([lignes containsObject:@"shon"]) 
	 	shiftHow = [[tempDico objectForKey:@"shon"] integerValue] ;		// shift on
	
	if ( (order = [lignes containsObject:@"ordre"]) )					// ordre des bits
	 { sordre = [tempDico objectForKey:@"ordre"] ; [self ordonne:sordre] ; }
		
	tablpari = 0 ;
	if ([lignes containsObject:@"pari"]) 
	 	tablpari = [[tempDico objectForKey:@"pari"] integerValue] ;		// parité

	subs = FIGu = LETr = baks = axen[0] = axen[1] = axen[2] = axen[3] = invar = soul = colr = 0 ;
	if ([lignes containsObject:@"divr"])
	 {	divr =  [tempDico objectForKey:@"divr"] ;
		subs = [[divr objectForKey:@"subs"] characterAtIndex:0] ;		// caractère substitution
		FIGu = (char)[[divr objectForKey:@"FIGu"] integerValue] ;		// SI ou Figure
		LETr = (char)[[divr objectForKey:@"LETr"] integerValue] ;		// SO ou Lettre
		baks = (char)[[divr objectForKey:@"baks"] integerValue] ;		// back space
//		axen[0] = (char)[[divr objectForKey:@"grav"] integerValue] ;	// accent grave
//		axen[1] = (char)[[divr objectForKey:@"aigu"] integerValue] ;	// accent aigue
//		axen[2] = (char)[[divr objectForKey:@"circ"] integerValue] ;	// accent circonflexe
//		axen[3] = (char)[[divr objectForKey:@"trma"] integerValue] ;	// accent tréma
		invar = [[divr objectForKey:@"invar"] integerValue] ;			// nombre de caractères invariables
		soul = (char)[[divr objectForKey:@"soul"] integerValue] ;		// souligné
		colr = [[divr objectForKey:@"colr"] integerValue] ;				// souligné, couleur, gras
	 } ;

	for (valr = 0 ; valr<257 ; valr++) tableCd[valr] = (unichar)subs ;				// 0 est un NULL sans action

	// Construction de la table de transcodage et de la liste des
	// caractères lus dans l'ordre des lignes du fichier de code.
	//
	F = [NSString stringWithString:[mf substringFromIndex:dfin.location+dfin.length]] ;	// garde le codage dans l'ordre du fichier
	[tmpArray removeAllObjects] ;
	debutLnNext=0; finString = [F length];															
	do  {
		[F getLineStart:&debutLn end:&debutLnNext contentsEnd:&finLn forRange:(NSRange){debutLnNext, 1} ];
		[mf setString:[F substringWithRange:(NSRange){debutLn, finLn-debutLn}]] ;
		if ([mf length]==0) continue ;
		noexep = YES ;
		@try { 
			ppl = [mf  propertyList] ;
		}
		@catch (NSException *ex) {
			noexep = NO ;
		}
		if (noexep && ([ppl count]>0))
		 {	indx = [[ppl allKeys] objectAtIndex:0] ;
			if ((indx==nil) || ([indx length]==0)) continue ;			// indx incorrect ?
			valr = [indx integerValue] ;
			G = [tempDico objectForKey:indx] ;							// valeur de la clef 
			if ((G==nil) || ([G length]==0)) continue ;					// pas de valeur ?
			
			[tmpArray addObject:indx ] ;								// semble correctes, écrit 
			if ([G length]>1)											// les deux tables
				tableCd[valr] = (unichar)[G integerValue] ;				// code action
			else 
				tableCd[valr] = [G characterAtIndex:0] ;				// caractère normal
		 } ;
	 }	while (debutLnNext < finString) ;

	[self attributs:0] ; 
	atri = Sou = MAJ = rtf = NO ; nomb = 0 ; 
	if ([brut length]==0) return YES ;									// vide -> return
	[fuori setData:brut] ;												// copie temporaire
	[brut setLength:0] ; [o_Text setString:@""] ;						// vide les résultats
	[self nextChar:fuori why:NO] ;										// ré-affiche
		
	return YES ;
}

// 0:normal, 1:souligné, 2:rouge, 3:rouge souligné, >=4:italique souligné
//
- (void)attributs:(NSInteger)quel
{
	[atts setDictionary:attr] ;
	switch (quel) {
		case 0:	break ;
		case 1: [atts setValue:[NSNumber numberWithInt:NSUnderlinePatternSolid |  NSUnderlineStyleSingle] 
														forKey:NSUnderlineStyleAttributeName] ;
				break ;
		case 2: [atts setValue:red forKey:NSForegroundColorAttributeName] ;
				break ;
		case 3: [atts setValue:[NSNumber numberWithInt:NSUnderlinePatternSolid |  NSUnderlineStyleSingle] 
														forKey:NSUnderlineStyleAttributeName] ;
				[atts setValue:red forKey:NSForegroundColorAttributeName] ;
				break ;
		default:[atts setValue:[NSNumber numberWithFloat:0.2] forKey:NSObliquenessAttributeName] ;
				[atts setValue:[NSNumber numberWithInt:NSUnderlinePatternSolid |  NSUnderlineStyleSingle] 
														forKey:NSUnderlineStyleAttributeName] ;
				break ;
	 }
}

// Affiche les caractères lisibles de la table
//
- (void)voirTable
{
unichar		kr, buff[256] ;
NSUInteger	nbr, cnt, fin ;
NSString	*leTitre ;

	fin =  [tmpArray count] ;
	
	[lu setString:@""] ;
	leTitre = [NSString stringWithFormat:@"\n%@\n", nameCode] ;
	[lu appendString:leTitre] ;
	[self affih:leTitre] ;
		
	for (cnt=0, nbr=0 ; nbr<fin ; nbr++)
	 {
		kr = tableCd[[[tmpArray objectAtIndex:nbr] integerValue]] ;
		if (kr>=32)
		 {	buff[cnt++] = kr ;
			if (cnt==64)
			 {	buff[cnt++] = (unichar)0x0d ;
				[lu appendString:[NSString stringWithCharacters:(const unichar *)buff length:cnt]] ;
				[self affih:[NSString stringWithCharacters:(const unichar *)buff length:cnt]] ;
				cnt = 0 ; [lu setString:@""] ;
			 } ;
		 } ;
	 } ; 
	if (cnt!=0)
	 {	buff[cnt++] = (unichar)0x0d ;
		buff[cnt++] = (unichar)0x0d ;
		[lu appendString:[NSString stringWithCharacters:(const unichar *)buff length:cnt]] ;
		[self affih:[NSString stringWithCharacters:(const unichar *)buff length:cnt]] ;
	 } ;
}

// ---------------------------------------

- (NSString *)defoCode													// accesseur lecture
{	return [NSString stringWithString:defoCode] ; }

- (void)setDefoCode:(NSString *)Kode									// accesseur écriture
{	[self faitTable:Kode] ; }

- (NSString *)chemin													// accesseur lecture
{	return [NSString stringWithString:chemin] ; }

- (void)setChemin:(NSString *)Kode										// accesseur écriture
{	[chemin setString:Kode] ; }

- (NSString *)mechin													// accesseur lecture
{	return [NSString stringWithString:mechin] ; }

- (void)setMechin:(NSString *)Kode										// accesseur écriture
{	[mechin setString:Kode] ; }

- (NSUInteger)masque
{	return tablmask ; }


// ---------------------------------------

// affichage 
//
- (void)nextChar:(NSData *)ceschar why:(BOOL)why						// ajout caractères
{
NSInteger x, z ;
char *pris ;

	cetest = why ;
	if ((z = [ceschar length]) > 0)
	 {	if (!cetest)
			[brut appendData:ceschar] ;									// cumule les données brutes
		pris = (char *)[ceschar bytes] ;								// pointe les données brutes
		
		if (([o_hexa state] == 1) || cetest)
		 {	for (x=0, nomb=0 ; x<z ; )
			 {	do {
				recu[nomb++] = pris[x++] ;								// copie les données reçues
				} while ((x%16 != 0) && (x < z)) ;						// par bloc de 16 caractères
				recu[nomb] = 0 ;										// 0 en fin de buffer
				[self hexaFlush] ;										// test de codage
				nomb = 0 ;
			 } ;
		 }
		else 
		 {	textatt = NO ;
			for (x=0 ; x<z ; x++)
				[self encdASCII:(pris[x] & tablmask) why:why] ;
			if (nomb!=0)
				[self purge] ;
		 } ;
	 } ;
 
}

- (void)nextChar:(NSData *)ceschar										// faire un attributedString
{
NSInteger x, z ;
char *pris ;

	textatt = YES ;
	if ([strtf length] > 0)
		[strtf deleteCharactersInRange:(NSRange){0,[strtf length]}] ;
	if ((z = [ceschar length]) > 0)
	 {	pris = (char *)[ceschar bytes] ;
		for (x=0 ; x<z ; x++)
			[self encdASCII:(pris[x] & tablmask) why:NO] ;
		if (nomb!=0)
				[self purge] ;
	 } ;
	textatt = NO ;
}


// Impression en Hexa avec traduction lisible si possible.
// 
- (void)hexaFlush
{
#define ligne 130
unichar rslt[ligne] ;
unichar ukr, rasci[ligne/2] ;
char kr ;
NSInteger x, y, z ;

	y = 0 ;
	rslt[y++] = (unichar)'\n' ;
	rslt[y++] = (unichar)' ' ;
	
	for (x=0 ; (x<16) && (x<(ligne-1)) ; x++)									// boucle sur caractère
	 {	if (x<nomb)
		 {	kr = recu[x] & (cetest ? 0xFF : (unsigned int)tablmask) ;			// caractère masqué sauf si test
			ukr = (unichar)(((kr>>4) & 0xF )+0x30) ;							// produit l'héxa
			rslt[y++] = (ukr>0x39) ? ukr+0x7 : ukr ;
			ukr = (unichar)((kr & 0xF )+0x30) ;									// produit l'héxa
			rslt[y++] = (ukr>0x39) ? ukr+0x7 : ukr ;
			rslt[y++] = (unichar)' ' ;
			if (!cetest) rasci[x] = [self hexaASCII:(NSUInteger)kr] ;
		 }
		else 
		 {	rslt[y++] = (unichar)' ' ; rslt[y++] = (unichar)' ' ;
			if (!cetest) rasci[x] = (unichar)0x20 ;
		 } ;

		if ((((x+1) % 8) == 0) && (x!=0))
		 	rslt[y++] = (unichar)' ' ;
	 } ;
	if (!cetest)																// pas d'ascii si en test
		for (z=0 ; z<x ; z++)
			rslt[y++] = rasci[z] ;
	 
	[self affih:[NSString stringWithCharacters:rslt length:y]] ;				// Affichage
}

// fait la liste des caractères qui doivent provoquer un arrêt en utilisant
// les boutons des préférences et les caractères d'arrêt du fichier de codes
//
- (void)carArret:(reglages)regl dest:(UInt8 *)dest
{
	*dest = 0;
	if (cetest) 
		return ;
	if ((regl.bCR==1) && (CRr[0]!=0))
		strcat((char *)dest, (const char *)CRr) ;
	if ((regl.bLF==1) && (LFr[0]!=0))
		strcat((char *)dest, (const char *)LFr) ;
	if ((regl.bETX==1) && (ETXr[0]!=0))
		strcat((char *)dest, (const char *)ETXr) ;	
	if ((regl.bEOT==1) && (EOTr[0]!=0))
		strcat((char *)dest, (const char *)EOTr) ;
	if ((regl.bETB==1) && (ETBr[0]!=0))
		strcat((char *)dest, (const char *)ETBr) ;
	if ((regl.bEM==1) && (EMr[0]!=0))
		strcat((char *)dest, (const char *)EMr) ;
	if ((regl.bFS==1) && (FSr[0]!=0))
		strcat((char *)dest, (const char *)FSr) ;
	if ((regl.bGS==1) && (GSr[0]!=0))
		strcat((char *)dest, (const char *)GSr) ;
	if ((regl.bRS==1) && (RSr[0]!=0))
		strcat((char *)dest, (const char *)RSr) ;
	if ((regl.bUS==1) && (USr[0]!=0))
		strcat((char *)dest, (const char *)USr) ;
}

// lit les caractères d'arrêt dans les propriétés du codage
//
- (void)codAret:(NSDictionary *)dico
{
	[self carK:dico bfr:CRr nm:@"CR"] ;
	[self carK:dico bfr:LFr nm:@"LF"] ;
	[self carK:dico bfr:ETXr nm:@"ETX"] ;
	[self carK:dico bfr:EOTr nm:@"EOT"] ;
	[self carK:dico bfr:ETBr nm:@"ETB"] ;
	[self carK:dico bfr:EMr nm:@"EM"] ;
	[self carK:dico bfr:FSr nm:@"FS"] ;
	[self carK:dico bfr:GSr nm:@"GS"] ;
	[self carK:dico bfr:RSr nm:@"RS"] ;
	[self carK:dico bfr:USr nm:@"US"] ;
}

- (void)carK:(NSDictionary *)dico bfr:(uint8 *)ut8 nm:(NSString *)nm
{
id lobjet ;
NSInteger d, e ;

	ut8[0] = 0 ;
	if ((lobjet = [dico objectForKey:nm]) == nil) return ;							// pas d'objet de ce nom
	if ((d = [lobjet count]) == 0) return ;											// objet sans valeur
	for (e=0 ; (e<d) && (e<4) ; e++)
	 {	ut8[e] = (uint8)[[lobjet objectAtIndex:e] integerValue] ;
		ut8[e+1] = 0 ; } ;
}

//----------------------------------------------------------------------------------
#define  extension   (litem==0 ? xbrt : (litem==1 ? @"txt" : (litem==2 ? @"rtf" : @"hxa" )))

// sauver un fichier
//
- (NSString *)priseFichier:(NSString *)defautNom									// savepanel spécifique
{ 
NSInteger	quoi ;
NSInteger	litem = [o_choix indexOfSelectedItem] ;

	choix_fichier = [NSSavePanel savePanel] ;										// créé l'objet savePanel
//	choix_fichier.delegate = self ;
	choix_fichier.showsTagField = NO ;
    choix_fichier.canSelectHiddenExtension=NO ;
	choix_fichier.treatsFilePackagesAsDirectories=NO ;								// ne pas ouvrir les bundles ?
    choix_fichier.canCreateDirectories = YES ;	    								// nouveau dossier Possible ?
	choix_fichier.message = [NSString stringWithFormat:@"%@", localiser(@"save1")] ;
	[choix_fichier setExtensionHidden:NO ] ;
	choix_fichier.nameFieldStringValue = ((mechin==nil) || (mechin.length == 0)) ? @"SanNom" : mechin.lastPathComponent ;

	choix_fichier.accessoryView = o_lavue ;
	choix_fichier.allowedFileTypes = @[litem==0 ? xbrt : (litem==1 ? @"txt" : (litem==2 ? @"rtf" : @"hxa" ))]  ;
	choix_fichier.directoryURL = [NSURL fileURLWithPath:defautNom] ;
	
	quoi = [choix_fichier runModal] ;
	if (quoi == NSCancelButton) return (@"") ;
	return [NSString stringWithString:[[choix_fichier URL] path]] ;					// nom complet du fichier
}

- (IBAction)a_chExtn:(id)sender
{
NSInteger	litem ;

	litem = [o_choix indexOfSelectedItem] ;
	choix_fichier.allowedFileTypes = @[litem==0 ? xbrt : (litem==1 ? @"txt" : (litem==2 ? @"rtf" : @"hxa" ))]  ;
}

- (NSString *)prise_Donnee:(NSString *)defautNom access:(BOOL)sory					// sory == YES -> .srt
{
NSArray		*les_fichiers ;
NSUInteger			quoi ;

	choix_donnee = [NSOpenPanel openPanel] ;										// créé l'objet openPanel
	choix_donnee.canChooseFiles = YES ;												// choisir un fichier
	choix_donnee.canChooseDirectories = NO ;										// dossier non
	choix_donnee.resolvesAliases = NO ;												// ne pas resoudre les alias
	choix_donnee.allowsMultipleSelection = NO ;										// pas de sélection multiple
	choix_donnee.message = localiser(sory ? @"load1"  : @"Ficode") ;				// le titre
	choix_donnee.canCreateDirectories = NO ;										// pas de nouveau dossier
	if (sory)
		[choix_donnee setAccessoryView:o_append] ;
	choix_donnee.allowedFileTypes = sory ? @[xbrt, @"hxa" ] : @[@"code"]  ;
	choix_donnee.directoryURL = [NSURL fileURLWithPath:defautNom] ;


	quoi = [choix_donnee runModal] ;
	if (quoi == NSFileHandlingPanelCancelButton) return (@"") ;						// annulé par l'utilisateur
	les_fichiers = [choix_donnee URLs] ;											// récupère la matrice des URLs
	if ( [les_fichiers count] == 0) return (@"") ;									// matrice vide ?
	return [NSString stringWithString:[[les_fichiers objectAtIndex:0] path]] ;		// retourne le fichier
}

//----------------------------------------------------------------------------------

- (void)affih:(NSString *)aVoir															// allonge le texte
{
	[ [o_Text textStorage] appendAttributedString: [[[NSAttributedString alloc] 
														initWithString:aVoir attributes:attr ] autorelease] ] ;
	[o_Text scrollRangeToVisible:NSMakeRange([[o_Text string] length], 0)] ;
}

- (NSString *)leDossier:(NSString *)piste 
{
BOOL  connu, estdir  ;
NSString *ledir ;
						
	connu = NO ;
	if ([piste length]!=0)					
	 {	connu = [[NSFileManager defaultManager] fileExistsAtPath:piste isDirectory:&estdir] ;
		ledir = ((!connu) || (connu && !estdir)) ? [piste stringByDeletingLastPathComponent] : piste   ;
	 }
	else 
	 {	ledir = [@"~/Desktop" stringByExpandingTildeInPath] ; } ;

	return [NSString stringWithString:ledir] ;
}

// fait un ficher texte d'héxa qui sera re-lisible
//
- (void)faitHexa											// fait les valeurs à sauver.
{
char		*Kpt, *jBuf ;
NSUInteger	g, h, j ;

	Kpt = [brut mutableBytes] ;								// pointeur des données
	g = [brut length] ;										// nbr de bytes
	[fuori  setLength:(g+2)*3] ;							// fait la place du résultat
	jBuf = [fuori mutableBytes] ;
	h=0 ;													// boucle
	do {
		j = h ;
		sprintf(&jBuf[h*3], "%02x", Kpt[h]) ;				// en héxa
		h++ ;
		if ( ((h%16) == 0) || ((h>=g) && (h!=0)) )
			jBuf[(j*3)+2] = (UInt8)'\n' ;					// tout les 20 caractères
		else 
			jBuf[(j*3)+2] = (UInt8)',' ;					// séparateur de caractères
			
	} while (h<=g) ;
	[fuori setLength:g*3] ;									// rectifie la longueur
}

// fait le texte simple .txt
//
- (void)faitText
{
	[self nextChar:brut] ;
	[fuori setData:[[strtf string] dataUsingEncoding:NSUnicodeStringEncoding]] ;
}

// fait le texte avec style .rtf
//
- (void)faitRTF
{
//NSDictionary *lattribut ;

	[self nextChar:brut] ;
	[fuori setData:[strtf RTFFromRange:(NSRange){0,[strtf length]} documentAttributes:atts]] ;
}

//  fait un fichier binaire
//
- (void)faitBin 
{
char		*Kpt, *jBuf, kar ;
uint8       locl, resu, lebit[] = {1,2,4,0x8,0x10,0x20,0x40,0x80} ;
NSUInteger	g, h, x ;

	Kpt = [brut mutableBytes] ;								// pointeur des données
	g = [brut length] ;										// nbr de bytes
	[fuori  setLength:(g+10)] ;								// fait la place du résultat
	jBuf = [fuori mutableBytes] ;
	
	for (h=0 ; h < g ; h++) 
	 {	kar = *Kpt++ & tablmask ;							// bits inutilisés à 0
	 	if (order)
	     for (x=0, resu=0 ; x<8 ; x++)    					// met les bits dans l'ordre
		  {	if (lordre[x] < 8) 
			 {	locl = lebit[lordre[x]] ;
				if ((locl & kar) != 0) resu |= lebit[x] ; 
			 }   
		  }
		else resu = kar ;									// ordre des bits inchangé
	 	
	 	*jBuf++ = resu ;
	 }
	[fuori setLength:h+2 ] ;								// rectifie la longueur
}

// met les bits dans l'ordre
//
- (void)ordonne:(NSString *)sordre
{
NSInteger  k, mn ;
	k =  [sordre length] ;
	mn = k > 8 ? 8 : k ;
	for (k=0 ; k < mn ; k++ )
	  lordre[k] = ((uint8)[sordre characterAtIndex:k]) - '0' ;
}

@end
