//
//  usbControle.m
//  HP2893
//
//  Créé par Miguel Saro le 01/05/10.
//  Tout droits réservés, - Cocoa Pod -, 2010.  
//

#import "usbControle.h"
#import "AppServices.h"
#import "prefs.h"
#import "defini.h"
#import "Console.h"
#import "AuFond.h"
#include "m600_common.h"
#include "m600.h"
#include "m600a.h"
#include "m600b.h"
#import "externes.h"

extern m600_alarms_t	alarms;

@interface usbControle (annexe)

- (void)metHexa ;

// Renvoie l'état du lecteur et de l'interface
- (void)show_alarms:(m600_bitmap_t)burf ;
- (void)lecture ;
- (void)valide:(BOOL)valid ;
- (void)mainThread_handle:(NSNotification *)note ;

@end

BOOL stopit ;
BOOL uneCrt ;

@implementation usbControle

- (IBAction)a_lire:(id)sender										// commande de lecture
{
	if (present)
	 {	if (!enCours)
		 {	uneCrt = [o_paquet selectedColumn] == 0 ;				// si YES -> 1 seule carte
			nbrCarte = 0 ;
			lues = NO ;
			[self lecture] ;
		 } ;
	 }
	else 
	 {	[o_lire setState:0] ;
		[o_lire setEnabled:YES] ;
		[o_stop setEnabled:NO] ;
		[NSApp auFeu:localiser(@"erreur05") bouton:nil icon:iCone] ;
	 } ;
}

- (IBAction)a_stop:(id)sender
{
	stopit = YES ;
}

- (IBAction)a_lirCod:(id)sender ;
{
	if (enCours) return ;
	enCours = YES ;
	[o_console voirCodage] ;								// affiche le codage dans la console	
	if (enCours) enCours = NO ;
}

- (IBAction)a_alarmes:(id)sender							// lecture de l'état du lecteur   à revoir
{
    if (m600_get_state() != M600_ERROR_SUCCESS)
	{	[NSApp auFeu:localiser(@"erreur02")  defBouton:nil icon:iCone] ; return ; } ;
	
	// [self show_alarms:alarms ] ;	
}												// */

- (IBAction)a_codeChange:(id)sender;			// Changement du fichier de code
{
NSString *fiCod ;
NSString *garde ;

	if (enCours) return ;
	enCours = YES ;
	fiCod = [NSApp prise_Dossier:localiser(@"Ficode") :(BOOL)NO :(BOOL)YES :[NSArray arrayWithObject:@"code"] ] ;
	if ([fiCod length] != 0)										// annuler!
	 {	garde = [NSString stringWithString:cheminCode] ;
		[cheminCode setString:fiCod] ;
		if (![o_console tableCodage:cheminCode])					// correct, retourne
		 {	[NSApp auFeu:[NSString stringWithFormat:localiser(@"coderr"), [NSApp pathUser:fiCod]] defBouton:@"Ok"] ;
			[cheminCode setString:garde] ;							// remet l'ancien code
			[o_console tableCodage:cheminCode] ;
		 } ;
	 } ;
	[self sauveReglage] ; 
	if (enCours) enCours= NO ;
}

- (IBAction)a_hexa:(id)sender
{
	[self metHexa] ;
}

- (IBAction)a_ibm029:(id)sender										// remet le codage par défaut
{
NSString *chemin ;

	if (enCours) return ;
	enCours = YES ;
	chemin = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:defautCode ] ;
	[cheminCode setString:chemin] ;
	[o_console tableCodage:(NSMutableString *)chemin] ;
	[self sauveReglage] ; 
	if (enCours) enCours = NO ;
}

- (IBAction)a_nerror:(id)sender
{
	if (!present)
	 {	[NSApp auFeu:localiser(@"erreur07") bouton:nil icon:iCone] ;
		return ; 
	 } ;															// */
	lues = NO ;
	m600_reset() ;
}

//------------------------------------------------------------ NSApp delegates   NSTimer

// au lancement
- (void) awakeFromNib
{	enCours = 1 ;
	brancher = [NSString stringWithString:localiser(@"lectoui")] ; [brancher retain] ;
	debrancher = [NSString stringWithString:localiser(@"lectnon")] ; [debrancher retain] ;
	[self metLeFond:o_fenetre] ;
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
BOOL			existe, dossier ;
m600_bitmap_t	beurk ;
NSAlert			*SOS ;
SInt32			osVrMajor ;
SInt32			osVrMinor ;
OSErr			iErMa, iErmi ;

	enCours = 0 ;
	iErMa = Gestalt(gestaltSystemVersionMajor, &osVrMajor) ;
	iErmi = Gestalt(gestaltSystemVersionMinor, &osVrMinor) ;
	if ((iErMa != noErr) || (iErmi != noErr) || (osVrMajor != OSxhma) || (osVrMinor < OSxlmi) || (osVrMinor > OSxlma))
	  {	SOS = [[NSAlert alloc] init] ;
		SOS.messageText = localiser(@"cantRun") ;
		SOS.informativeText = [NSString stringWithString: localiser(@"upgradeMacOS") ] ;
		[SOS runModal] ;
		[NSApp terminate:self];
	  } ;
	 
	iNext = [NSImage imageNamed:@"next"] ; [iNext retain] ;
	iBack = [NSImage imageNamed:@"back"] ; [iBack retain] ;
	iCone = [NSImage imageNamed:@"Documa.png"] ; [iCone retain] ;
	cheminCode = [NSMutableString stringWithCapacity:50] ; [cheminCode setString:@""] ;  [cheminCode retain] ;
	gestionFichier = [NSFileManager defaultManager] ; [gestionFichier retain] ;
	[o_console consoleInit] ;
	m600_Init() ;

	[self defautsExiste] ;												// récupère les réglages  filemanager
	
	existe = [gestionFichier fileExistsAtPath:cheminCode isDirectory:&dossier ] ;	
	if (existe && !dossier)
		existe = [o_console tableCodage:cheminCode] ;					// construit la table de codage.
	
	if (!existe || dossier)												// chemin existe et c'est un fichier ?
	 {	[self defautReglages] ;											// non! remet les réglages par défaut.
		[o_console tableCodage:cheminCode] ; } ;						// refait la table IBM029
		
	hexa = [o_hexa state] ; 
	[self metHexa] ;
		
 	[o_theBox setContentView:o_vueStart] ;								// launch with start view
	
	present = YES ;
	beurk = m600_open() ; 
	[self show_alarms:beurk] ;

	enCours = 0 ;
	lues = NO ;
	
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(anyThread_handle:) name:m600notification object:nil];
	queue = [[NSOperationQueue alloc] init] ;
	[queue retain] ;
	
	isPresent = [NSTimer scheduledTimerWithTimeInterval:0.5  target:self 
							selector:@selector(testPresent:)  userInfo:nil  repeats:YES];
	[self valide:YES] ;
	present = NO ;
}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	if (enCours) 
		return NSTerminateCancel ;
	return NSTerminateNow ;
}

- (void)replyToApplicationShouldTerminate:(BOOL)shouldTerminate
{
	return ;
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	m600_close() ;
	m600_cleanup() ;
	if (isPresent != nil) [isPresent invalidate] ;
	[self sauveReglage] ; 
}

- (BOOL)windowShouldClose:(id)sender
{
	return !enCours ;						// fermer l'appli
}

- (void)windowWillClose:(NSNotification *)notification
{
id maWindow ;

	maWindow = [notification object] ;
	if (maWindow == o_fenetre)
		[NSApp terminate:self] ;
}

// -----------------------------------------------------------------------------------------

- (void)valide:(BOOL)valid
{
	[o_lire setEnabled:valid] ;
	[o_stop setEnabled:!valid] ;
}

- (void)lanceOp															// lance la queue d'opération.
{
m600a	*creve ;														// l'objet alloué

	[queue cancelAllOperations];
	
	creve = [[m600a alloc] initialise:[m600b class]  queue:queue] ;

	[queue setMaxConcurrentOperationCount:2] ;
	[queue addOperation:creve];											// lance l'exécution
	[self valide:NO] ;
	
	[creve release] ;
}																		// */

- (void)lecture
{
	if (!present)
	 {	[NSApp auFeu:localiser(@"erreur05") bouton:nil icon:iCone] ;	// appareil est présent ?
		return ; 
	 } ;																//   */    
	[self sauveReglage] ;												// sauve les réglages 
	enCours=YES ;
	[self valide:NO] ;
	
	[self lanceOp] ;													// lancer l'opération

}  

- (void)show_alarms:(m600_bitmap_t)burf
{
NSString  *M6Bpt ;
NSAlert  *lalert = [[NSAlert alloc] init] ;

	if ((burf & (M600_BIT_ERROR | M600_BIT_M600_ERROR)) == 0) 	return ;	// pas d'erreur
	
	present = (burf & M600_BIT_NOT_CONNECTED) == 0 ;
	
	if (!present)															// non connecté
		M6Bpt = @"M6B6" ; 
		  
	else 
	 {	if ((burf & M600_BIT_HOPPER_CHECK) != 0)
		 {	
			M6Bpt = lues ? @"M6B7" : @"M6B4" ; 								// case départ vide
			lues = NO ; 													// ou fin du paquet
		 }
		else
		 {	if ((M600_BIT_ERROR & burf) != 0)
			 {	if ((burf & M600_BIT_UNDEF) != 0)
					M6Bpt = @"M6B1" ;										// erreur non définie
				else if ((burf & M600_BIT_IO) != 0)
					M6Bpt = @"M6B2" ;										// erreur connexion USB
				else if ((burf & M600_BIT_USER) != 0)
					M6Bpt = @"M6B8" ;										// Arrêt opérateur
				else
					M6Bpt = @"M6B0" ;										// erreur inconnue
			 }
			else
			 {	if ((burf & M600_BIT_MOTION_CHECK) != 0)
					M6Bpt = @"M6B5" ;										// Lecteur: erreur déplacement des cartes
				else
					M6Bpt = @"M6B3" ;										// Lecteur: erreur génériqu
			 } ;
		 } ;
	 } ;

	[o_etat setStringValue:localiser( present ? @"lectoui" : @"lectnon")] ;
	lalert.messageText= [NSString stringWithString:localiser(@"defoTitre") ] ;
	lalert.informativeText = [NSString stringWithString : localiser(M6Bpt) ] ;
    [lalert runModal] ;

}

// transmet à la console l'état du bouton "Héxa"
- (void)metHexa
{
	if (enCours) return ;
	hexa=[o_hexa state] ;
	[o_console metLhexa:hexa] ;
}

- (void)testPresent:(NSTimer*)theTimer
{
	present = find_m600_device() ;
	[o_etat setStringValue:present ? brancher : debrancher ] ; 
}

// Recevoir les notifications ----------------------------------------------------

// -------------------------------------------------------------------------------
//	anyThread_handle:note
//
//	This method is called from any possible thread (any NSOperation)
//	The notification contains the NSDictionary 
// -------------------------------------------------------------------------------
- (void)anyThread_handle:(NSNotification *)note
{
	[self performSelectorOnMainThread:@selector(mainThread_handle:) withObject:note waitUntilDone:YES];
}

// -------------------------------------------------------------------------------
//	mainThread_handle:note
//
//	note est le dictionnaire des informations à traiter.
//	The notification contains an NSDictionary
// -------------------------------------------------------------------------------
- (void)mainThread_handle:(NSNotification *)note				
{
NSInteger	module ;
NSInteger	nbre ;

	module = [[[note userInfo] objectForKey:@"module"] integerValue] ;		// code de l'envoi
	nbre = [[[note userInfo] objectForKey:@"nbre"] integerValue] ;			// nbr de caractère
	if (nbre != 0)															// envoi à l'affichage
	 {	[o_console prendre:[[note userInfo] objectForKey:@"card"] why:module] ;
		nbrCarte++ ;
	 } ;
	if ((module != M600_BIT_NO_ERROR) || uneCrt)							// dernier envoi si YES
	 {	[queue cancelAllOperations];
		if (module != M600_BIT_NO_ERROR)[self show_alarms:module] ;
		enCours = NO ; 
		[self valide:YES] ;
	 } ;
	lues = YES ;
}

@end
