/*
** Made by fabien le mentec <texane@gmail.com>
** 
** Started on  Tue Nov 17 04:21:01 2009 fabien le mentec
** Last update Sat Apr 10 09:18:05 2010 texane
*/

#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdbool.h>
#include "debug.h"
#include "m600.h"

extern int nbrCarte, crtCarte, suivi ;
extern uint16_t *badPtr ;

#define CONFIG_LIBUSB_VERSION 1


/* utility macro */

#define GOTO_ERROR(E)	\
  do {			\
    error = E;		\
    goto on_error;	\
  } while (0)
  

// globales  ------------------------------------------------------------------------

m600_handle_t*  myhandle ;								// handle du lecteur
uint16_t card_buffer[M600_COLUMN_COUNT];				// buffer des données lues.
m600_alarms_t	alarms;

// forward declarations
void close_m600_usb_handle(usb_dev_handle* usb_handle) ;
m600_error_t open_m600_usb_handle(usb_dev_handle** usb_handle, int enum_only) ;

/* implementation ------------------------------------------------------------------ */

/* endianness */

static int is_mach_le = 0;

static inline int get_is_mach_le(void)
{
  const uint16_t magic = 0x0102;

  if ((*(const uint8_t*)&magic) == 0x02)
    return 1;

  return 0;
}

static inline uint16_t le16_to_mach(uint16_t n)
{
  if (!is_mach_le)
    return ((n >> 8) & 0xff) | ((n & 0xff) << 8) ;

  return n;
}

// allocation myhandle
m600_handle_t* alloc_m600_handle()
{
	m600_handle_t* handle = malloc(sizeof(m600_handle_t));
	if (handle != NULL)
	 {	handle->usb_handle = NULL;
		return handle; } ;
		
    return NULL	;
}

// libérer le handle
void free_m600_handle(m600_handle_t *handle)
{
  free(handle);
}


// is the usb device a m600 card reader
static int is_m600_device(const struct usb_device *dev)
{

	if ((dev->descriptor.idVendor == M600_USB_VENDOR_ID) && (dev->descriptor.idProduct == M600_USB_PRODUCT_ID))
		return 1 ;
	return 0;
}

static m600_error_t send_recv_cmd( m600_handle_t* handle, m600_cmd_t* cmd)
{
  /* timeouts in ms */
#define CONFIG_DEFAULT_TIMEOUT (2000)

	if ( usb_bulk_write(handle->usb_handle, handle->ep_req, (void*)&cmd->req,
										(int)sizeof(cmd->req), CONFIG_DEFAULT_TIMEOUT) >= 0)
		if (usb_bulk_read(handle->usb_handle, handle->ep_rep, (void*)&cmd->rep,
										(int)sizeof(cmd->rep), CONFIG_DEFAULT_TIMEOUT) >= 0)
			return M600_ERROR_SUCCESS;

    return M600_ERROR_LIBUSB ;
}


static m600_error_t send_recv_cmd_or_reopen( m600_handle_t* handle, m600_cmd_t* cmd)
{
  /* send_recv_cmd or reopen handle on libusb failure */

  m600_error_t error = send_recv_cmd(handle, cmd);
  if (error != M600_ERROR_SUCCESS)
  {
    if (find_m600_dev() != 0)
		GOTO_ERROR(M600_ERROR_NOT_FOUND);

    /* reopen the usb handle */

    close_m600_usb_handle(myhandle->usb_handle);

    error = open_m600_usb_handle(&handle->usb_handle, 0);
    if (error != M600_ERROR_SUCCESS)
      GOTO_ERROR(error);

    /* resend the command */

    error = send_recv_cmd(handle, cmd);
  }

 on_error:
  return error;
}


/* find m600 device wrapper */

int find_m600_dev()
{  
usb_dev_handle* dummy_handle;

	dummy_handle = NULL;
	const m600_error_t error = open_m600_usb_handle(&dummy_handle, 1);
	if (error == M600_ERROR_NOT_FOUND)
								return -1 ;				// -1 device non trouvé
	return 0 ;											// 0, device trouvé
}


/* reset the device */

static m600_error_t reset_m600(m600_handle_t* handle)
{
  m600_cmd_t cmd;
  cmd.req = M600_REQ_RESET_DEV;
  return send_recv_cmd(handle, &cmd);
}


/* is the device ready */

m600_error_t is_m600_ready(m600_handle_t *handle, bool *is_ready)
{
  m600_error_t error;

  error = m600_read_alarms() ;									//objc
  if (error != M600_ERROR_SUCCESS)
    return error;

  *is_ready = true ;
  if (M600_IS_ALARM(alarms, NOT_READY))
    *is_ready = false ;

  return M600_ERROR_SUCCESS;
}

void close_m600_usb_handle(usb_dev_handle* usb_handle)
{
  usb_close(usb_handle);
}

m600_error_t open_m600_usb_handle(usb_dev_handle** usb_handle, int enum_only)
{
  /* enum_only is used when we only wants to find
     the m600 device. */

  m600_error_t error;
  struct usb_bus* bus;

  *usb_handle = NULL;

  usb_find_busses();
  usb_find_devices();

  for (bus = usb_busses; bus != NULL; bus = bus->next)
  {
    struct usb_device* dev;
    for (dev = bus->devices; dev != NULL; dev = dev->next)
    {
      if (is_m600_device(dev))
      {
		if (enum_only)
			GOTO_ERROR(M600_ERROR_SUCCESS);

		*usb_handle = usb_open(dev);
		if (*usb_handle == NULL)
			GOTO_ERROR(M600_ERROR_LIBUSB);

		if (usb_set_configuration(*usb_handle, 2))
			GOTO_ERROR(M600_ERROR_LIBUSB);

		if (usb_claim_interface(*usb_handle, 0))
			GOTO_ERROR(M600_ERROR_LIBUSB);

		return M600_ERROR_SUCCESS;
      }
    }
  }

  /* not found */
  error = M600_ERROR_NOT_FOUND;

 on_error:

  if (*usb_handle != NULL)
  {
    usb_close(*usb_handle);
    *usb_handle = NULL;
  }
  return error;
}

m600_bitmap_t  alarms_to_bitmap(m600_alarms_t alarms)
{
m600_bitmap_t local;

	local = 0 ;
		 if (M600_IS_ALARM(alarms, HOPPER_CHECK))
			local |= M600_BIT_HOPPER_CHECK ;
	else if (M600_IS_ALARM(alarms, MOTION_CHECK))
			local |= M600_BIT_MOTION_CHECK ;
	else if (M600_IS_ALARM(alarms, NOT_READY))
			local |= M600_BIT_NOT_READY ;
	else if (M600_IS_ALARM(alarms, ERROR))
			local |= M600_BIT_M600_ERROR ;

	if (local) local |= M600_BIT_M600_ERROR;
	return local ;
}


m600_bitmap_t error_to_bitmap(m600_error_t error)
{
m600_bitmap_t local;

	local = 0 ;
	if (error != 0)
	 {	switch (error)	{
	
		case M600_ERROR_NOT_FOUND:	local |= M600_BIT_NOT_CONNECTED;
									break;
		case M600_ERROR_LIBUSB:
		case M600_ERROR_IO:
		case M600_ERROR_TIMEOUT:	local |= M600_BIT_IO;
									break;
		default:					local |= M600_BIT_UNDEF;
									break;
		} ;
	 } ;
	
  	if (local) local |= M600_BIT_ERROR;
	return local ;
}


//--------------------------------------------------------------------------------  Exportées  ---------------

// -- méthodes différentes suivant que l'on est en simulation ou non. ----------------------------------------
//

#ifndef simlCarte 

// retourne YES si le lecteur est trouvé
//
bool find_m600_device()
{
	return (find_m600_dev() == 0) ;
}

// initialisation de la librairie et des variables globales.
//
m600_error_t  m600_Init()
{
	is_mach_le = get_is_mach_le();
  	usb_init() ;
	
	return M600_ERROR_SUCCESS ;
}																		// */

// ouverture du périphérique
//
m600_bitmap_t  m600_open()
{
m600_error_t	error;
usb_dev_handle	*usb_handle ;

	usb_handle = NULL;
	myhandle = NULL;

	/* open usb device */

	error = open_m600_usb_handle(&usb_handle, 0);						// a voir
	if (error == M600_ERROR_SUCCESS)  
	 {	/* open and init the device */
		myhandle = alloc_m600_handle() ;								// a voir
		if (myhandle == NULL)  
			error = M600_ERROR_MEMORY ;
		else
		 {	myhandle->usb_handle = usb_handle;
			myhandle->ep_req = M600_USB_EP_REQ | USB_ENDPOINT_OUT;
			myhandle->ep_rep = M600_USB_EP_REP | USB_ENDPOINT_IN;
			error = M600_ERROR_SUCCESS ;
		 } ;
	 } ;

	return  error_to_bitmap(error) ;
}

// fermeture du périphérique
//
void  m600_close()		
{
	if (myhandle == NULL)
		return ;
	if (myhandle->usb_handle != NULL)
		usb_close(myhandle->usb_handle) ;

	free_m600_handle(myhandle) ;
}

// netoyage de ??
//
void m600_cleanup()
{
  /* nop */
}

bool isM600Open()
{
	return myhandle != NULL ;
}

// prise de l'état de la machine et de l'usb
//
m600_bitmap_t  m600_get_state()
{
m600_error_t	error ;

	if (find_m600_dev() != 0)								// machine connectée?
		return ( M600_BIT_ERROR | M600_BIT_NOT_CONNECTED) ;

	error = m600_read_alarms() ;
	
	if (error == M600_ERROR_SUCCESS)
		return alarms_to_bitmap(alarms) ;					// pas d'erreur dans la lecture des alarmes
	else
	 	return error_to_bitmap(error) ;						// erreur dans la lecture des alarmes
}

m600_error_t  m600_reset()
{
  return reset_m600(myhandle);
}


// lecture des alarmes
//
m600_error_t  m600_read_alarms()
{
m600_error_t	error;
m600_cmd_t		cmde;

	alarms = 0;
	cmde.req = M600_REQ_READ_ALARMS;

	error = send_recv_cmd_or_reopen(myhandle,&cmde) ;
	if (error != M600_ERROR_SUCCESS)    
		return  error;

	alarms = le16_to_mach(cmde.rep.alarms) ;
	return M600_ERROR_SUCCESS ;
}

// lire une carte
//
m600_bitmap_t m600_read_card()
{
m600_bitmap_t	bitmap;
m600_error_t	error;
m600_cmd_t		cmd;
int				i, j ; 
bool			pret ;

	bitmap  = error = 0 ;
	
// remplace ----> error = m600_read_cards(myhandle, 1, convert_buffer, &alarmes) ; Sleep
  
	error = m600_read_alarms() ;									// check for device alarms */
	if (error != M600_ERROR_SUCCESS)
		GOTO_ERROR(error);

	if (alarms)
	{
		if (M600_IS_SINGLE_ALARM(alarms, NOT_READY))				// reset the device if not ready  A REVOIR
		{
			error = reset_m600(myhandle);							// do reset
			if (error != M600_ERROR_SUCCESS)
				GOTO_ERROR(error);
			
			for (j=0 ; j<8 ; j++)
			 {														// delais+test  de 8 secondes
				error = is_m600_ready(myhandle, &pret) ;
				if (error != M600_ERROR_SUCCESS)
								GOTO_ERROR(error);
				if (pret) exit ;
				sleep(1) ;									// A VOIR  delay ou sleep!
			 } ;
		 }
		else
		 {	M600_OTHER_ALARM(alarms, NOT_READY) ;					// si autre alarme que NOT_READY
			GOTO_ERROR(error);
		 } ;
	} ;
	
	cmd.req = M600_REQ_READ_CARD;

	error = send_recv_cmd_or_reopen(myhandle, &cmd);
    if (error == M600_ERROR_SUCCESS)
		for ( i=0 ; i<M600_COLUMN_COUNT ; i++)
			card_buffer[i]= ~ le16_to_mach(cmd.rep.card_data[i]) ;
	GOTO_ERROR(error);

// --------------------------------------------------

on_error:
	
	if (error == M600_ERROR_SUCCESS)
		return alarms_to_bitmap(alarms) ;							// pas d'erreur dans la lecture des alarmes
	else
	 	return error_to_bitmap(error) ;								// erreur dans la lecture des alarmes
}

#else

// remplace les méthodes supprimées.
#include "m_6mul.c"      

#endif           // */





