//
//  usbControle.m
//  HP2893
//
//  Créé par Miguel Saro le 01/05/10.
//  Tout droits réservés, - Cocoa Pod -, 2010.  
//

#import "usbControle.h"
#import "AppServices.h"
#import "prefs.h"
#import "def.h"
#import "Console.h"
#import "m600.h"
#import "AuFond.h"
#import "defini.h"

@interface usbControle (annexe)

- (void)metHexa ;

// Renvoie l'état du lecteur et de l'interface
- (void)show_alarms:(m600_bitmap_t)burf ;

@end


@implementation usbControle

- (IBAction)a_lire:(id)sender										// commande de lecture
{
int				x ;
m600_bitmap_t	beurk ;

	if (enCours > 0) return ;										// */
	if (!present)
	 {	[NSApp auFeu:[NSApp localiser:@"erreur05"] bouton:nil icon:iCone] ;
		return ; 
	 } ;															// */
	if (isM600Open()==false)
	 { 	beurk = m600_open() ; 
		if (beurk)
		  {	NSLog(@"Impossible d'ouvrir le device") ;
			return ; } ;
	 } ;
	enCours++ ;
	[self sauveReglage] ; 
	maxi = [o_paquet selectedColumn] == 0 ? 1 : maxPacket ;			// 1 carte ou le paquet ?
	
	for ( x=0, beurk=M600_ERROR_SUCCESS ; x<maxi &&  beurk==M600_ERROR_SUCCESS ; x++)
	 {	if ((beurk = m600_read_card()) != 0)						// lire une carte
		 	[self show_alarms:beurk] ;								// trouvé une erreur
		else
		 {	[o_console prendre] ;									// pas d'erreur
			present = lues = YES ;									// prendre les données
		 } ;
			
	 } ;
	 
	 if (enCours>0) enCours-- ;
}

- (IBAction)a_lirCod:(id)sender ;
{
	if (enCours > 0) return ;
	enCours++ ;
	[o_console voirCodage] ;								// affiche le codage dans la console	
	if (enCours>0) enCours-- ;
}

- (IBAction)a_alarmes:(id)sender							// lecture de l'état du lecteur   à revoir
{
    if (m600_get_state() != M600_ERROR_SUCCESS)
	{	[NSApp auFeu:[NSApp localiser:@"erreur02"]  defBouton:nil icon:iCone] ; return ; } ;
	
	// [self show_alarms:alarms ] ;	
}												// */

- (IBAction)a_codeChange:(id)sender;			// Changement du fichier de code
{
NSString *fiCod ;
NSString *garde ;

	enCours++ ;
	fiCod = [NSApp prise_Dossier:[NSApp localiser:@"Ficode"] :(BOOL)NO :(BOOL)YES :[NSArray arrayWithObject:@"code"] ] ;
	if ([fiCod length] != 0)										// annuler!
	 {	garde = [NSString stringWithString:cheminCode] ;
		[cheminCode setString:fiCod] ;
		if (![o_console tableCodage:cheminCode])					// correct, retourne
		 {	[NSApp auFeu:[NSString stringWithFormat:[NSApp localiser:@"coderr"], [NSApp pathUser:fiCod]] defBouton:@"Ok"] ;
			[cheminCode setString:garde] ;							// remet l'ancien code
			[o_console tableCodage:cheminCode] ;
		 } ;
	 } ;
	[self sauveReglage] ; 
	if (enCours>0) enCours-- ;
}

- (IBAction)a_hexa:(id)sender
{
	[self metHexa] ;
}

- (IBAction)a_ibm029:(id)sender										// remet le codage par défaut
{
NSString *chemin ;

	if (enCours) return ;
	enCours++ ;
	chemin = [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:defautCode ] ;
	[cheminCode setString:chemin] ;
	[o_console tableCodage:(NSMutableString *)chemin] ;
	[self sauveReglage] ; 
	if (enCours>0) enCours-- ;
}

- (IBAction)a_nerror:(id)sender
{
	if (!present)
	 {	[NSApp auFeu:[NSApp localiser:@"erreur07"] bouton:nil icon:iCone] ;
		return ; 
	 } ;															// */
	m600_reset() ;
}

//------------------------------------------------------------ NSApp delegates   NSTimer

// au lancement
- (void) awakeFromNib
{	enCours = 1 ;
	brancher = [NSString stringWithString:[NSApp localiser:@"lectoui"]] ; [brancher retain] ;
	debrancher = [NSString stringWithString:[NSApp localiser:@"lectnon"]] ; [debrancher retain] ;
	[self metLeFond:o_fenetre] ;
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
BOOL			existe, dossier ;
m600_bitmap_t	beurk ;
NSAlert			*SOS ;
SInt32			osVrMajor ;
SInt32			osVrMinor ;
OSErr			iErMa, iErmi ;

	enCours = 0 ;
	iErMa = Gestalt(gestaltSystemVersionMajor, &osVrMajor) ;
	iErmi = Gestalt(gestaltSystemVersionMinor, &osVrMinor) ;
	if ((iErMa != noErr) || (iErmi != noErr) || (osVrMajor != OSxhma) /*|| (osVrMinor < OSxlmi) || (osVrMinor > OSxlma)*/)
	  {	SOS = [[NSAlert alloc] init] ;
		SOS.messageText = localiser(@"cantRun") ;
		SOS.informativeText = [NSString stringWithString: localiser(@"upgradeMacOS") ] ;
		[SOS runModal] ;
		[NSApp terminate:self];
	  } ;
	 
	iNext = [NSImage imageNamed:@"next"] ; [iNext retain] ;
	iBack = [NSImage imageNamed:@"back"] ; [iBack retain] ;
	iCone = [NSImage imageNamed:@"Documa.png"] ; [iCone retain] ;
	cheminCode = [NSMutableString stringWithCapacity:50] ; [cheminCode setString:@""] ;  [cheminCode retain] ;
	gestionFichier = [NSFileManager defaultManager] ; [gestionFichier retain] ;
	[o_console consoleInit] ;
	m600_Init() ;

	[self defautsExiste] ;												// récupère les réglages  filemanager
	
	existe = [gestionFichier fileExistsAtPath:cheminCode isDirectory:&dossier ] ;	
	if (existe && !dossier)
		existe = [o_console tableCodage:cheminCode] ;					// construit la table de codage.
	
	if (!existe || dossier)												// chemin existe et c'est un fichier ?
	 {	[self defautReglages] ;											// non! remet les réglages par défaut.
		[o_console tableCodage:cheminCode] ; } ;						// refait la table IBM029
		
	hexa = [o_hexa state] ; 
	[self metHexa] ;
		
//	[o_drawer setContentSize:(NSSize){150.0, 200.0}] ;
//	[o_drawer close];
 	[o_theBox setContentView:o_vueStart] ;								// launch with start view
	
	present = YES ;
	beurk = m600_open() ; 
	[self show_alarms:beurk] ;

	enCours = 0 ;
	lues = NO ;
	[self metTimer] ;
}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	if (enCours > 0) 
		return NSTerminateCancel ;
	return NSTerminateNow ;
}

- (void)replyToApplicationShouldTerminate:(BOOL)shouldTerminate
{
	return ;
}

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
	if (enCours > 0) 
		return NO ;
	return YES ;
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	m600_close() ;
	m600_cleanup() ;
	if (isPresent != nil) [isPresent invalidate] ;
	[self sauveReglage] ; 
}

- (BOOL)windowShouldClose:(id)sender
{
	if (enCours > 0) 
		return NO ;						// ne pas fermer, travail en cours
//	[o_console consoleFerme] ;			// ferme la console si ouverte
	return YES ;						// fermer l'appli
}

- (void)windowWillClose:(NSNotification *)notification
{
id maWindow ;

	maWindow = [notification object] ;
	if (maWindow == o_fenetre)
		[NSApp terminate:self] ;
}

		
- (void)show_alarms:(m600_bitmap_t)burf
{
NSString  *M6Bpt ;
NSAlert  *lalert = [[NSAlert alloc] init] ;

	if ((burf & (M600_BIT_ERROR | M600_BIT_M600_ERROR)) == 0) 	return ;	// pas d'erreur
	
	present = (burf & M600_BIT_NOT_CONNECTED) == 0 ;
	
	if (!present)															// non connecté
		M6Bpt = @"M6B6" ; 
		  
	else 
	 {	if ((burf & M600_BIT_HOPPER_CHECK) != 0)
		 {	lues = lues && (maxi != 1) ;
			M6Bpt = lues ? @"M6B7" : @"M6B4" ; 								// case départ vide
			lues = NO ; }													// ou fin du paquet
		  
		else
		 {	if ((M600_BIT_ERROR & burf) != 0)
			 {	if ((burf & M600_BIT_UNDEF) != 0)
					M6Bpt = @"M6B1" ;										// erreur non définie
				else if ((burf & M600_BIT_IO) != 0)
					M6Bpt = @"M6B2" ;										// erreur connexion USB
				else
					M6Bpt = @"M6B0" ;										// erreur inconnue
			 }
			else
			 {	if ((burf & M600_BIT_MOTION_CHECK) != 0)
					M6Bpt = @"M6B5" ;										// Lecteur: erreur déplacement des cartes
				else
					M6Bpt = @"M6B3" ;										// Lecteur: erreur génériqu
			 } ;
		 } ;
	 } ;

	[o_etat setStringValue:localiser( present ? @"lectoui" : @"lectnon")] ;
	lalert.messageText= [NSString stringWithString:localiser(@"defoTitre") ] ;
	lalert.informativeText = [NSString stringWithString : localiser(M6Bpt) ] ;
    [lalert runModal] ;

}


// transmet à la console l'état du bouton "Héxa"
- (void)metHexa
{
	if (enCours) return ;
	hexa=[o_hexa state] ;
	[o_console metLhexa:hexa] ;
}

- (void)metTimer
{ 
	isPresent = [NSTimer scheduledTimerWithTimeInterval:0.5  target:self 
							selector:@selector(testPresent:)  userInfo:nil  repeats:YES];
	present = NO ;
}

- (void)testPresent:(NSTimer*)theTimer
{
	present = find_m600_device() ;
	[o_etat setStringValue:present ? brancher : debrancher ] ; 
}

@end
